<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

return new class extends Migration {
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('portals', function (Blueprint $table) {
            $table->id();
            $table->string('name', 255);
            $table->string('status', 60)->default('published');
            $table->string('tema', 255)->nullable();
            $table->string('subtema', 255)->nullable();
            $table->string('acordao', 255)->nullable();
            $table->string('autor', 255)->nullable();
            $table->string('legislacao', 255)->nullable();
            $table->string('tipoProcesso', 255)->nullable();
            $table->string('tags', 255)->nullable();
            $table->timestamps();
        });

        Schema::create('portals_translations', function (Blueprint $table) {
            $table->string('lang_code');
            $table->integer('portals_id');
            $table->string('name', 255)->nullable();

            $table->primary(['lang_code', 'portals_id'], 'portals_translations_primary');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('portals');
        Schema::dropIfExists('portals_translations');
    }
};