<?php

Route::group(['namespace' => 'Botble\Portal\Http\Controllers', 'middleware' => ['web', 'core']], function () {

    Route::group(['prefix' => BaseHelper::getAdminPrefix(), 'middleware' => 'auth'], function () {

        Route::group(['prefix' => 'portals', 'as' => 'portal.'], function () {
            Route::resource('', 'PortalController')->parameters(['' => 'portal']);
            Route::delete('items/destroy', [
                'as' => 'deletes',
                'uses' => 'PortalController@deletes',
                'permission' => 'portal.destroy',
            ]);
        });
    });
    if (defined('THEME_MODULE_SCREEN_NAME')) {
        Route::group(apply_filters(BASE_FILTER_GROUP_PUBLIC_ROUTE, []), function () {
            Route::get('services', [
                'as' => 'public.search',
                'uses' => 'PublicPortalController@getSearch',
            ]);
        });
    }

});