<?php

namespace Botble\Portal\Forms;

use Botble\Base\Forms\FormAbstract;
use Botble\Base\Enums\BaseStatusEnum;
use Botble\Portal\Http\Requests\PortalRequest;
use Botble\Portal\Models\Portal;

class PortalForm extends FormAbstract
{

    /**
     * {@inheritDoc}
     */
    public function buildForm()
    {
        $this
            ->setupModel(new Portal)
            ->setValidatorClass(PortalRequest::class)
            ->withCustomFields()
            ->add('name', 'textarea', [
                'label' => trans('core/base::forms.name'),
                'label_attr' => ['class' => 'control-label required'],
                'attr' => [
                    'placeholder' => trans('core/base::forms.name_placeholder')
                ],
            ])
            ->add('tema', 'text', [
                'label' => 'tema',
                'label_attr' => ['class' => 'control-label'],
                'attr' => [
                    'placeholder' => 'placeholder',
                    'data-counter' => 120,
                ],
            ])
            ->add('subtema', 'textarea', [
                'label' => 'subtema',
                'label_attr' => ['class' => 'control-label'],
                'attr' => [
                    'rows' => 4,
                    'placeholder' => trans('core/base::forms.description_placeholder'),
                    'data-counter' => 400,
                ],
            ])

            ->add('status', 'customSelect', [
                'label' => trans('core/base::tables.status'),
                'label_attr' => ['class' => 'control-label required'],
                'attr' => [
                    'class' => 'form-control select-full',
                ],
                'choices' => BaseStatusEnum::labels(),
            ])
            ->setBreakFieldPoint('status');
    }
}