<?php

namespace Botble\Portal\Http\Controllers;

use Botble\Base\Enums\BaseStatusEnum;
use Botble\Portal\Repositories\Interfaces\PortalInterface;
use Illuminate\Support\Facades\Request;
use Botble\Portal\Models\Portal;
use Theme;

class PublicPortalController
{
    public function getAllServices(PortalInterface $portalRepository)
    {
        $services = $portalRepository->allBy(['status' => BaseStatusEnum::PUBLISHED]);

        Theme::breadcrumb()
            ->add(__('Home'), route('public.index'))
            ->add(('Services'), route('public.services'));

        // scope(view,data,default view)
        return Theme::scope('portal', compact('services'))->render();
    }
    public function getSearch(Request $request)
    {
        $portals = Portal::all(); // Recupera todos os registros da tabela "portals"

        Theme::breadcrumb()
            ->add(__('Home'), route('public.index'))
            ->add(__('search'), route('public.search'));

        return Theme::scope('well', compact('portals'), 'plugins/portal::well')->render();
    }

    public function getServiceById($slug, PortalInterface $portalRepository)
    {
        $service = $portalRepository->allBy(['slug' => $slug])->first();
        return Theme::scope('services', compact('service'), 'plugins/services::service')->render();
    }
}