<?php

namespace Botble\Portal\Models;

use Botble\Base\Traits\EnumCastable;
use Botble\Base\Enums\BaseStatusEnum;
use Botble\Base\Models\BaseModel;


class Portal extends BaseModel
{
    use EnumCastable;

    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'portals';

    /**
     * @var array
     */
    protected $fillable = [
        'name',
        'tema',
        'subtema',
        'acordao',
        'autor',
        'legislacao',
        'tipoProcesso',
        'status',
    ];

    /**
     * @var array
     */
    protected $casts = [
        'status' => BaseStatusEnum::class,
    ];
}