<?php

namespace Botble\Portal\Providers;

use Botble\Portal\Models\Portal;
use Illuminate\Support\ServiceProvider;
use Botble\Portal\Repositories\Caches\PortalCacheDecorator;
use Botble\Portal\Repositories\Eloquent\PortalRepository;
use Botble\Portal\Repositories\Interfaces\PortalInterface;
use Illuminate\Support\Facades\Event;
use Botble\Base\Traits\LoadAndPublishDataTrait;
use Illuminate\Routing\Events\RouteMatched;


use Botble\Blog\Models\Category;
use Botble\Blog\Repositories\Caches\CategoryCacheDecorator;
use Botble\Blog\Repositories\Eloquent\CategoryRepository;
use Botble\Blog\Repositories\Interfaces\CategoryInterface;
use Botble\Blog\Models\Tag;
use Botble\Blog\Repositories\Caches\TagCacheDecorator;
use Botble\Blog\Repositories\Eloquent\TagRepository;
use Botble\Blog\Repositories\Interfaces\TagInterface;
use Language;
use Note;
use SeoHelper;
use SlugHelper;

class PortalServiceProvider extends ServiceProvider
{
    use LoadAndPublishDataTrait;

    public function register()
    {
        $this->app->bind(PortalInterface::class, function () {
            return new PortalCacheDecorator(new PortalRepository(new Portal));
        });

        $this->setNamespace('plugins/portal')->loadHelpers();
    }

    public function boot()
    {
        $this
            ->loadAndPublishConfigurations(['permissions'])
            ->loadMigrations()
            ->loadAndPublishTranslations()
            ->loadAndPublishViews()
            ->loadRoutes(['web']);

        if (defined('LANGUAGE_MODULE_SCREEN_NAME')) {
            if (defined('LANGUAGE_ADVANCED_MODULE_SCREEN_NAME')) {
                // Use language v2
                \Botble\LanguageAdvanced\Supports\LanguageAdvancedManager::registerModule(Portal::class, [
                    'name',
                ]);
            } else {
                // Use language v1
                $this->app->booted(function () {
                    \Language::registerModule([Portal::class]);
                });
            }
        }

        Event::listen(RouteMatched::class, function () {
            dashboard_menu()->registerItem([
                'id' => 'cms-plugins-portal',
                'priority' => 5,
                'parent_id' => null,
                'name' => 'plugins/portal::portal.name',
                'icon' => 'fa fa-list',
                'url' => route('portal.index'),
                'permissions' => ['portal.index'],
            ]);
        });
    }
}