<?php
    $featuredPosts = get_featured_posts($limit ?: 5, ['slugable', 'categories', 'categories.slugable']);
?>

<div class="featured-slider-2">
    <div class="featured-slider-2-items">
        <?php $__currentLoopData = $featuredPosts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $post): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="slider-single">
                <div class="post-thumb position-relative">
                    <div class="thumb-overlay position-relative" style="background-image: url(<?php echo e(RvMedia::getImageUrl($post->image, null, false, RvMedia::getDefaultImage())); ?>)">
                        <div class="post-content-overlay">
                            <div class="container">
                                <div class="entry-meta meta-0 font-small mb-20">
                                    <?php $__currentLoopData = $post->categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <a href="<?php echo e($category->url); ?>" tabindex="<?php echo e($loop->index); ?>"><span class="post-cat <?php echo e(random_color()); ?> text-uppercase"><?php echo e($category->name); ?></span></a>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                                <h1 class="post-title mb-20 font-weight-900 text-white">
                                    <a class="text-white" href="<?php echo e($post->url); ?>"><?php echo e($post->name); ?></a>
                                </h1>
                                <div class="entry-meta meta-1 font-small text-white mt-10 pr-5 pl-5">
                                    <span class="post-on"><?php echo e($post->created_at->diffForHumans()); ?></span>
                                    <span class="hit-count has-dot"><?php echo e(number_format($post->views)); ?> <?php echo e(__('views')); ?></span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
    <div class="container position-relative">
        <div class="arrow-cover color-white"></div>
        <div class="featured-slider-2-nav-cover">
            <div class="featured-slider-2-nav">
                <?php $__currentLoopData = $featuredPosts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $post): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="slider-post-thumb mr-15 mt-20 position-relative">
                        <div class="d-flex hover-up-2 transition-normal">
                            <div class="post-thumb post-thumb-80 d-flex mr-15 border-radius-5">
                                <img class="border-radius-5" src="<?php echo e(RvMedia::getImageUrl($post->image, 'thumb', false, RvMedia::getDefaultImage())); ?>" alt="<?php echo e($post->name); ?>">
                            </div>
                            <div class="post-content media-body text-white">
                                <h5 class="post-title mb-15 text-limit-2-row"><?php echo e($post->name); ?></h5>
                                <div class="entry-meta meta-1 float-left font-x-small text-uppercase">
                                    <span class="post-on text-white"><?php echo e($post->created_at->diffForHumans()); ?></span>
                                    <span class="hit-count has-dot text-white"><?php echo e(number_format($post->views)); ?> <?php echo e(__('views')); ?></span>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </div>
</div>
<?php /**PATH /home/nanaferrocom/public_html/platform/themes/stories/partials/short-codes/featured-posts-slider-full.blade.php ENDPATH**/ ?>