<?php
    $featuredPosts = get_featured_posts($limit ?: 3, ['slugable', 'categories', 'categories.slugable']);
?>

<div class="bg-grey pb-30">
    <div class="container pt-30">
        <div class="featured-slider-3 position-relative">
            <div class="slider-3-arrow-cover"></div>
            <div class="featured-slider-3-items">
                <?php $__currentLoopData = $featuredPosts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $post): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="slider-single overflow-hidden border-radius-10">
                        <div class="post-thumb position-relative">
                            <div class="thumb-overlay position-relative" style="background-image: url(<?php echo e(RvMedia::getImageUrl($post->image, null, false, RvMedia::getDefaultImage())); ?>)">
                                <div class="post-content-overlay">
                                    <div class="container">
                                        <div class="entry-meta meta-0 font-small mb-20">
                                            <?php $__currentLoopData = $post->categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <a href="<?php echo e($category->url); ?>" tabindex="<?php echo e($loop->index); ?>"><span class="post-cat <?php echo e(random_color()); ?> text-uppercase"><?php echo e($category->name); ?></span></a>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </div>
                                        <h1 class="post-title mb-20 font-weight-900 text-white">
                                            <a class="text-white" href="<?php echo e($post->url); ?>" tabindex="<?php echo e($loop->index); ?>"><?php echo e($post->name); ?></a>
                                        </h1>
                                        <div class="entry-meta meta-1 font-small text-white mt-10 pr-5 pl-5">
                                            <span class="post-on"><?php echo e($post->created_at->diffForHumans()); ?></span>
                                            <span class="hit-count has-dot"><?php echo e(number_format($post->views)); ?> <?php echo e(__('views')); ?></span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </div>
</div>
<?php /**PATH /home/nanaferrocom/public_html/platform/themes/stories/partials/short-codes/featured-posts-slider.blade.php ENDPATH**/ ?>